# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from common.util import log


def execute(dev_obj):
    """
    查询OceanStor 9000设备节点信息
    :param dev_obj: 设备信息
    :return:
    """
    ssh = dev_obj.get("SSH")
    # 防止设备踢session
    ssh.execCmdWithTimout("TMOUT=0", 20)
    # 查询节点信息
    cmd = "sudo /opt/huawei/snas/bin/OceanStor9000_datacollect.sh queryNode"
    cli_ret = ssh.execCmdWithTimout(cmd, 30)
    parser_cli_ret(dev_obj, cli_ret)
    return bool(dev_obj.get("result")), ""


def parser_cli_ret(dev_obj, cli_ret):
    result = dev_obj.get("result")
    list_cli_ret = cli_ret.splitlines()
    for line in list_cli_ret:
        node_dit = {}
        if "SUBDOMAIN_ID" in line:
            node_info = line.split(",")
            node_dit["name"] = node_info[0]
            node_dit["Leader"] = parser_node_info(node_dit, node_info)
            result.add(node_dit)
    log.info(dev_obj, "node_dit is {}".format(result))


def parser_node_info(node_dit, node_info):
    leader = ""
    for info in node_info:
        if "SUBDOMAIN_ID" in info:
            node_dit["SUBDOMAIN_ID"] = info.split(":")[1]
            continue
        if "NODEPOOLID" in info:
            node_dit["NODEPOOLID"] = info.split(":")[1]
            continue
        if "Leader" in info and str(info.split(":")[1]) == "1":
            leader = leader + info.split(":")[0] + " "
    return leader.strip().replace(" ", ",")
